﻿using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancelOutbound
{
    /// <summary>
    /// Get Facilities Step.
    /// </summary>
    public class GetFacilitiesStep : FilterBase<MakeCancelOutboundStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(MakeCancelOutboundStateObject state)
        {
            using (var srv = new Xrm(state.OrganizationServiceProxy))
            {
                //var tsa = srv.mcs_servicesSet.FirstOrDefault(x => x.Id == state.ServiceAppointment.mcs_relatedtsa.Id);
                //if (tsa == null) throw new Exception($"The TSA cannot be null for appointment id {state.ServiceAppointmentId}");
                var patientSite = state.ServiceAppointment.mcs_relatedsite;

                if (patientSite != null)
                {
                    if (state.AppointmentType != AppointmentType.GROUP)
                    {
                        state.PatientFacility = (from f in srv.mcs_facilitySet
                                                join s in srv.mcs_siteSet on f.Id equals s.mcs_FacilityId.Id
                                                where s.Id == patientSite.Id
                                                select f).FirstOrDefault();
                        if (state.PatientFacility == null) throw new Exception("The Patient Facility is missing");
                    }
                    else
                    {
                        //TODO: Need to Review/Revisit the logic for Group Appointments
                        //var patientSite = srv.mcs_siteSet.FirstOrDefault(s => s.Id == state.Appointment.cvt_Site.Id);
                        //if (patientSite?.mcs_FacilityId == null) throw new Exception("The Patient Site is missing or Facility is missing");

                        //state.PatientFacility = srv.mcs_facilitySet.FirstOrDefault(f => f.Id == patientSite.mcs_FacilityId.Id);
                        //if (state.PatientFacility == null) throw new Exception("The Patient Facility is missing");
                    }
                }

                if (state.ServiceAppointment.mcs_relatedprovidersite == null) return;

                state.ProviderFacility = (from f in srv.mcs_facilitySet
                                            join s in srv.mcs_siteSet on f.Id equals s.mcs_FacilityId.Id
                                            where s.Id == state.ServiceAppointment.mcs_relatedprovidersite.Id
                                            select f).FirstOrDefault();
                if (state.ProviderFacility == null) throw new Exception("The Provider Facility is missing");
            }
        }
    }
}